/* UndoController */

#import <Cocoa/Cocoa.h>
#import "Tile.h"

@interface UndoController : NSObject
{
	NSMutableArray* undo_list;

	NSMutableArray* current_move;
}

- (id)init;
- (void)dealloc;

- (id)clearUndoBuffer;
- (id)startMove;
- (id)addTile :(Tile*)tile;
- (id)endMove;
- (int)tilesInCache;

- (int)undoCount;

- (NSMutableArray*)lastMove;
- (id)removeLastMove;

@end
